#version 330
#extension GL_EXT_gpu_shader4 : enable
//Times TableMod01.fsh  by  Deirin
//https://www.shadertoy.com/view/WlsSRB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const int pointsCount = 99;
float radius    = .45;
const float thickness = .0005;
float timesTableSubject = 1.;
const float colorIntensity = 2.;
const float TAU = 6.28318530718;
const float speed = .8;

float Circle( in vec2 c, in float r ) {
    return length( c ) - r;
}

float Union( in float a, in float b ) {
    return min( a, b );
}

float sdLine( in vec2 p, in vec2 a, in vec2 b ) {
    vec2 pa = p-a, ba = b-a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
    vec2 uv     = gl_FragCoord.xy / iResolution.xy;    
    vec2 center = ( uv - .5 );
    float angle = TAU / float( pointsCount );
    
    timesTableSubject += iTime * speed;
    
    center.x *= iResolution.x / iResolution.y;   
    
    radius += abs(sin(iTime)) * .05;
    float sdf = Circle( center, radius );
    sdf       = abs( sdf ) - thickness;
    
    for( int i = 0; i < pointsCount; i++ ) {
        vec2 sPoint = vec2( cos( angle * float(i) ) * radius + center.x, sin( angle * float(i) ) * radius + center.y );
        int targetPointIndex = int( mod( ( float( i + 1 ) ) * timesTableSubject, float( pointsCount ) ) );
        vec2 tPoint = vec2( cos( angle * float(targetPointIndex) ) * radius + center.x, sin( angle * float(targetPointIndex) ) * radius + center.y );
        sdf = Union( sdf, sdLine( vec2(0.,0.), sPoint, tPoint) );
    }
    
    float pulseCircle = abs( Circle(center, fract(iTime*.8))) - thickness;
    sdf = min(sdf, pulseCircle);
    sdf = smoothstep(0.005, 0.0, sdf);
    float bg = sin(Circle(center,radius));
    bg = min(bg, sin(bg*130.*sin(iTime)));
    sdf = max(bg, sdf);
    
    gl_FragColor = vec4( vec3( sin(iTime)*.5+.5,sin(iTime+TAU/3.)*.5+.5,sin(iTime+TAU*2./3.)*.5+.5) * sdf * colorIntensity, 1 );
}

